"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteWatch = deleteWatch;
exports.deleteWatchRoute = deleteWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function deleteWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'delete',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`deleteWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function deleteWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, deleteWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfY29uc3RhbnRzIiwiZGVsZXRlV2F0Y2giLCJjbHVzdGVyQ2xpZW50IiwibG9nZ2VyIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsInBhcmFtcyIsImlkIiwiaGVhZGVycyIsInNndGVuYW50IiwiTk9fTVVMVElURU5BTkNZX1RFTkFOVCIsInBhdGgiLCJlbmNvZGVVUklDb21wb25lbnQiLCJyZXNwIiwiYXNTY29wZWQiLCJhc0N1cnJlbnRVc2VyIiwidHJhbnNwb3J0IiwibWV0aG9kIiwib2siLCJib2R5IiwiZXJyIiwiZXJyb3IiLCJzdGFjayIsImN1c3RvbUVycm9yIiwic2VydmVyRXJyb3IiLCJkZWxldGVXYXRjaFJvdXRlIiwicm91dGVyIiwiZGVsZXRlIiwiUk9VVEVfUEFUSCIsIldBVENIIiwidmFsaWRhdGUiLCJzY2hlbWEiLCJvYmplY3QiLCJzdHJpbmciXSwic291cmNlcyI6WyJkZWxldGUuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgIENvcHlyaWdodCAyMDIwIGZsb3JhZ3VubiBHbWJIXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQGtibi9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IHNlcnZlckVycm9yIH0gZnJvbSAnLi4vLi4vbGliL2Vycm9ycyc7XG5pbXBvcnQgeyBST1VURV9QQVRILCBOT19NVUxUSVRFTkFOQ1lfVEVOQU5UIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29tbW9uL3NpZ25hbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGRlbGV0ZVdhdGNoKHsgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pIHtcbiAgcmV0dXJuIGFzeW5jIGZ1bmN0aW9uIChjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSkge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHBhcmFtczogeyBpZCB9LFxuICAgICAgICBoZWFkZXJzOiB7IHNndGVuYW50ID0gTk9fTVVMVElURU5BTkNZX1RFTkFOVCB9LFxuICAgICAgfSA9IHJlcXVlc3Q7XG5cbiAgICAgIGNvbnN0IHBhdGggPSBgL19zaWduYWxzL3dhdGNoLyR7ZW5jb2RlVVJJQ29tcG9uZW50KHNndGVuYW50KX0vJHtlbmNvZGVVUklDb21wb25lbnQoaWQpfWA7XG5cbiAgICAgIGNvbnN0IHJlc3AgPSBhd2FpdCBjbHVzdGVyQ2xpZW50LmFzU2NvcGVkKHJlcXVlc3QpLmFzQ3VycmVudFVzZXIudHJhbnNwb3J0LnJlcXVlc3Qoe1xuICAgICAgICBtZXRob2Q6ICdkZWxldGUnLFxuICAgICAgICBwYXRoLFxuICAgICAgfSk7XG5cbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7IGJvZHk6IHsgb2s6IHRydWUsIHJlc3AgfSB9KTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGxvZ2dlci5lcnJvcihgZGVsZXRlV2F0Y2g6ICR7ZXJyLnN0YWNrfWApO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbUVycm9yKHNlcnZlckVycm9yKGVycikpO1xuICAgIH1cbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRlbGV0ZVdhdGNoUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KSB7XG4gIHJvdXRlci5kZWxldGUoXG4gICAge1xuICAgICAgcGF0aDogYCR7Uk9VVEVfUEFUSC5XQVRDSH0ve2lkfWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGlkOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGRlbGV0ZVdhdGNoKHsgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pXG4gICk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFnQkEsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsT0FBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsVUFBQSxHQUFBRixPQUFBO0FBbEJBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFNTyxTQUFTRyxXQUFXQSxDQUFDO0VBQUVDLGFBQWE7RUFBRUM7QUFBTyxDQUFDLEVBQUU7RUFDckQsT0FBTyxnQkFBZ0JDLE9BQU8sRUFBRUMsT0FBTyxFQUFFQyxRQUFRLEVBQUU7SUFDakQsSUFBSTtNQUNGLE1BQU07UUFDSkMsTUFBTSxFQUFFO1VBQUVDO1FBQUcsQ0FBQztRQUNkQyxPQUFPLEVBQUU7VUFBRUMsUUFBUSxHQUFHQztRQUF1QjtNQUMvQyxDQUFDLEdBQUdOLE9BQU87TUFFWCxNQUFNTyxJQUFJLEdBQUksbUJBQWtCQyxrQkFBa0IsQ0FBQ0gsUUFBUSxDQUFFLElBQUdHLGtCQUFrQixDQUFDTCxFQUFFLENBQUUsRUFBQztNQUV4RixNQUFNTSxJQUFJLEdBQUcsTUFBTVosYUFBYSxDQUFDYSxRQUFRLENBQUNWLE9BQU8sQ0FBQyxDQUFDVyxhQUFhLENBQUNDLFNBQVMsQ0FBQ1osT0FBTyxDQUFDO1FBQ2pGYSxNQUFNLEVBQUUsUUFBUTtRQUNoQk47TUFDRixDQUFDLENBQUM7TUFFRixPQUFPTixRQUFRLENBQUNhLEVBQUUsQ0FBQztRQUFFQyxJQUFJLEVBQUU7VUFBRUQsRUFBRSxFQUFFLElBQUk7VUFBRUw7UUFBSztNQUFFLENBQUMsQ0FBQztJQUNsRCxDQUFDLENBQUMsT0FBT08sR0FBRyxFQUFFO01BQ1psQixNQUFNLENBQUNtQixLQUFLLENBQUUsZ0JBQWVELEdBQUcsQ0FBQ0UsS0FBTSxFQUFDLENBQUM7TUFDekMsT0FBT2pCLFFBQVEsQ0FBQ2tCLFdBQVcsQ0FBQyxJQUFBQyxtQkFBVyxFQUFDSixHQUFHLENBQUMsQ0FBQztJQUMvQztFQUNGLENBQUM7QUFDSDtBQUVPLFNBQVNLLGdCQUFnQkEsQ0FBQztFQUFFQyxNQUFNO0VBQUV6QixhQUFhO0VBQUVDO0FBQU8sQ0FBQyxFQUFFO0VBQ2xFd0IsTUFBTSxDQUFDQyxNQUFNLENBQ1g7SUFDRWhCLElBQUksRUFBRyxHQUFFaUIscUJBQVUsQ0FBQ0MsS0FBTSxPQUFNO0lBQ2hDQyxRQUFRLEVBQUU7TUFDUnhCLE1BQU0sRUFBRXlCLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNwQnpCLEVBQUUsRUFBRXdCLG9CQUFNLENBQUNFLE1BQU0sQ0FBQztNQUNwQixDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0RqQyxXQUFXLENBQUM7SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FDdkMsQ0FBQztBQUNIIn0=